	function PLOT_ATT_Z_LS(wT, ATT, ATT_p)
	
	% 	Plots the attenuation in linear scale given the frequency response 
	%	of a digital filter
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2007-10-07
	% 	Modified by: 	LW 2008-07-09	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:			 
	% 	Known bugs:
	% 	Report bugs to:	Wanhammar@gmail.com
	
	%========================================================	
	% Standard settings
	fs = 14; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================		 
	plot(wT, ATT,'linewidth', 2); 
 	axis([min(wT), max(wT), 0, ATT_p]);	
	set(gca,'FontName', 'times','FontSize', 16);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};	
	
	x = floor(max(wT)*10/pi);
	for n = 9:-1:x
		ax(end) = [];	lab(end) = [];
	end
	x = 0;

	while x < min(wT)
		x = x + ax(1);
		ax(1) = [];
		lab(1) = [];
	end
	 
	if max(wT) <= 0.2*pi
		ax = [0 0.05*pi 0.1*pi 0.15*pi 0.2*pi];
		lab = {'0';'0.05\pi';'0.1\pi';'0.15\pi';'0.2\pi'};
	end
	if max(wT) <= 0.01*pi
		ax = [0  0.025*pi 0.05*pi];		
		lab = {'0';'0.025\pi';'0.05\pi'};
	end	
	if max(wT) <= 0.05*pi
		ax = [0 0.025*pi  0.05*pi];
		lab = {'0';'0.0.25\pi';'0.05\pi'};
	end

	ylabel(['{\itA}({\ite^j^\omega^T})'],'FontName', fn,'FontSize',fs);	
	xlabel('{\it\omegaT} [rad]');	
	xtick(ax,lab);
	grid on;
